/*
**	exec.c
**
**	Find the program and execute it; all the while handling gracefully
**	things like pipes and routed output, etc.
*/

#include "make.h"
#include "commands.h"
#include "job.h"
#include "file.h"
#include <errno.h>
#include <process.h>

/*
 *	This is where we basically pretend that we are the shell
 */

static void fix_to_dos(char *sp)
{
	for (; *sp; sp++)
		if (*sp == '/')
			*sp = '\\';
}

static char *default_exts[] = { "", ".exe", ".com", NULL };

static char *find_path(char *dst, char *src)
{
	int i;
  	char prg[PATH_MAX];
	
	for (i = 0; default_exts[i]; i++)
	{
		strcpy(prg, src);
		strcat(prg, default_exts[i]);
		if (!_path(dst, prg))
			return dst;
	}
	return NULL;
}

static char *escaped_chars = "\'\";| \t\\&()\n";

typedef struct _responsRec
{
	struct _responsRec *next;
	char				path[PATH_MAX];
} *rspPtr;

int exec_command(argPtr argv, char **envp)
{
  	char prg[PATH_MAX];
  	char cwd[PATH_MAX];
	char command[105];
	rspPtr response = NULL;
	argPtr cargv;
	int result = -1, i;
	int len = 0;
	int cpos, ccnt, rpos;

	for (len = i = 0; argv->ptrs[i]; i++)
	{
		if (argv->ptrs[i][0] == '\'')
		{
			char *sp;

			argv->ptrs[i][0] = '\"';
			if (sp = strrchr(argv->ptrs[i], '\''))
				*sp = '\"';
		}
		len += strlen(argv->ptrs[i]) + 1;
	}

	getcwd(cwd, sizeof(cwd));
	for (cpos = 0; cpos < argv->ptr_used;)
	{
		rspPtr old;
		int needs_shell = 0;
		char *rsp;

		for (ccnt = 0; cpos + ccnt < argv->ptr_used; ccnt++)
		{
			i = cpos + ccnt;
			if (argv->ptrs[i][0] == '|' || argv->ptrs[i][0] == '>'
				|| argv->ptrs[i][0] == '<' || argv->ptrs[i][0] == '&')
				needs_shell = 1;
			if (argv->ptrs[i][0] == ';')
				break;
		}
		for (rpos = cpos; rpos + 1 < cpos + ccnt;)
		{
			FILE *fp;
			int del_cnt;

			for (len = 1, i = cpos; i < cpos + ccnt; i++)
				len += strlen(argv->ptrs[i]) + 1;
			if (len <= sizeof(command))
				break;

			for (del_cnt = 0, i = rpos + 1; i < cpos + ccnt; i++, del_cnt++)
				if (argv->ptrs[i][0] == '|' || argv->ptrs[i][0] == '>'
					|| argv->ptrs[i][0] == '<' || argv->ptrs[i][0] == '&')
					break;
			if (del_cnt > 1)
			{
				old = response;
				response = (rspPtr)xmalloc(sizeof(*response));
				rsp = response->path;
				response->next = old;

				rsp[0] = '\0';
				if (!tmpnam(rsp+1))
					sprintf(rsp + 1, "/respn%03d.tmp", rpos); 
				fix_to_dos(rsp+1);

				if (fp = fopen(rsp+1, "wt"))
				{
					rsp[0] = '@';
					printf("Creating response file: %s\n", rsp);
					for (i = rpos + 1; i <= rpos + del_cnt; i++)
					{
						char *sp, *dp;

						sp = dp = argv->ptrs[i];
						for (; *sp; sp++)
						{
							if (*sp == '\\' && sp[1] && strchr(escaped_chars, sp[1]))
								;	/* Just skip it, we'll pick it up next time. */
							else
								*dp++ = *sp;
						}
						*dp = '\0';
						fprintf(fp, "%s\n", argv->ptrs[i]);
					}
					fclose(fp);
					argPtr_delete(argv, rpos + 1, del_cnt);
					argPtr_insert(argv, rpos + 1, &rsp, 1);
				}
				ccnt -= del_cnt;
				ccnt++;
			}
			for (; rpos < cpos + ccnt; rpos++)
				if (argv->ptrs[rpos][0] == '|' || argv->ptrs[rpos][0] == '&')
				{
					rpos++;
					break;
				}
		}

		cargv = argPtr_new(128);
		for (i = cpos; i < cpos + ccnt; i++)
			argPtr_add(cargv, argv->ptrs[i]);
		if (!needs_shell)
		{
			if (rsp = find_path(prg, cargv->ptrs[0]))
			{
				argPtr_delete(cargv, 0, 1);
				argPtr_insert(cargv, 0, &rsp, 1);
			}
			else
				needs_shell = 1;
		}
		if (needs_shell)
		{
			char *add = "/c";

			rsp = getenv ("COMSPEC");
			if (!rsp)
   			{
				if (_emx_env & 0x0200)	/* Under OS/2 */
					rsp = find_path(prg, "cmd.exe");
				else
					rsp = find_path(prg, "command.com");
				if (!rsp)
				{
					error("Unable locate command shell.");
					abort();
				}
   			}
			argPtr_insert(cargv, 0, &add, 1);
			argPtr_insert(cargv, 0, &rsp, 1);
		}
		if (debug_flag)
		{
			printf("::");
			for (i = 0; cargv->ptrs[i]; i++)
				printf(" %s", cargv->ptrs[i]);
			printf("\n");
		}
		result = spawnve(P_WAIT, cargv->ptrs[0], (char const * const *)cargv->ptrs, (char const * const *)envp);
		argPtr_free(cargv);
		while (response)
		{
			old = response->next;
			unlink(response->path+1);
			xfree(response);
			response = old;
		}
		if (_read_kbd(0, 0, 1) == 3) /* Control-C to quit */
			abort();
		cpos += ccnt;
		while (cpos < argv->ptr_used && argv->ptrs[cpos][0] == ';')
			cpos++;
	}
	chdir(cwd);
	return result;
}

/* End of File */
